<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('firstname', 200)->index();
			$table->string('surname', 200)->index();
			$table->string('street', 200);
			$table->string('housenr', 20);
			$table->string('box', 20);
			$table->string('postal_code', 50);
			$table->string('city', 200);
			$table->string('country', 5);
			$table->string('email', 500)->index();
			$table->string('phone', 50)->index();
			$table->string('mobile', 50)->index();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}