<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomRoomTypesTable extends Migration {

	public function up()
	{
		Schema::create('room_room_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('room_id')->unsigned()->index();
			$table->integer('room_type_id')->unsigned()->index();
			$table->integer('capacity')->unsigned()->nullable();
			$table->tinyInteger('is_default')->unsigned()->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('room_room_types');
	}
}