<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlocksTable extends Migration {

	public function up()
	{
		Schema::create('blocks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('block_type_id')->unsigned()->index();
			$table->integer('center_id')->unsigned()->index();
			$table->string('code', 50);
			$table->string('description', 50);
		});
	}

	public function down()
	{
		Schema::drop('blocks');
	}
}