<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingDietsTable extends Migration {

	public function up()
	{
		Schema::create('booking_diets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('booking_id')->unsigned()->index();
			$table->integer('diet_id')->unsigned()->index();
			$table->integer('nbr_adults')->default('0');
			$table->integer('nbr_children')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('booking_diets');
	}
}