<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealTypesTable extends Migration {

	public function up()
	{
		Schema::create('meal_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('center_id')->unsigned()->index();
			$table->string('description', 50)->index();
			$table->time('timing_default');
			$table->time('timing_start')->index();
			$table->time('timing_end')->index();
		});
	}

	public function down()
	{
		Schema::drop('meal_types');
	}
}