<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingConsumptionsTable extends Migration {

	public function up()
	{
		Schema::create('booking_consumptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('booking_id')->unsigned()->index();
			$table->integer('location_id')->unsigned()->nullable()->index();
			$table->integer('consumption_id')->unsigned()->index();
			$table->integer('qty_start')->unsigned();
			$table->integer('qty_final')->unsigned();
			$table->integer('qty_start_bulk')->nullable();
			$table->integer('qty_final_bulk')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('booking_consumptions');
	}
}