<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingRoomsTable extends Migration {

	public function up()
	{
		Schema::create('booking_rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('booking_id')->unsigned()->index();
			$table->integer('room_id')->unsigned()->index();
			$table->integer('room_type_id')->unsigned()->index();
			$table->datetime('date_from')->nullable()->index();
			$table->datetime('date_to')->nullable()->index();
			$table->integer('nbr_people')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('booking_rooms');
	}
}