<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Room extends Eloquent {

	protected $table = 'rooms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function comfort_type()
	{
		return $this->hasOne('App\Models\ComfortType');
	}

	public function block()
	{
		return $this->hasOne('App\Models\Block');
	}

	public function types()
	{
		return $this->hasManyThrough('App\Models\RoomType', 'App\Models\RoomRoomType');
	}

}