<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseInvoiceItemsTable extends Migration {

	public function up()
	{
		Schema::create('purchase_invoice_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('purchase_invoice_id')->nullable();
			$table->integer('item_id');
			$table->double('amount')->default('0');
			$table->float('purchase_price')->default('0');
			$table->float('sale_price')->default('0');
			$table->float('unit_price')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('purchase_invoice_items');
	}
}