<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesPerformasTable extends Migration {

	public function up()
	{
		Schema::create('sales_performas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('inventory_id')->nullable();
			$table->integer('customer_id');
			$table->string('code')->nullable();
			$table->date('date')->nullable();
			$table->float('total')->default('0');
			$table->integer('created_by')->nullable();
			$table->timestamp('confirmed_at')->nullable();
			$table->integer('confirmed_by')->nullable();
			$table->string('status', 10)->default('OPEN');
			$table->text('notes')->nullable();
			$table->string('discount_type', 10)->default('percent');
			$table->float('discount_amount')->default('0');
			$table->float('total_discount')->default('0');
			$table->float('taxes_amount')->default('0');
			$table->enum('performa_type', array(''piece'', ''half'', ''whole_sale''));
		});
	}

	public function down()
	{
		Schema::drop('sales_performas');
	}
}