<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryAdjustmentItemsTable extends Migration {

	public function up()
	{
		Schema::create('inventory_adjustment_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('inventory_adjustment_id');
			$table->integer('item_id');
			$table->integer('inventory_item_id');
			$table->double('old_amount')->default('0');
			$table->double('new_amount')->default('0');
			$table->string('type', 10)->default('INCREASE');
		});
	}

	public function down()
	{
		Schema::drop('inventory_adjustment_items');
	}
}