<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesPerformaItemsTable extends Migration {

	public function up()
	{
		Schema::create('sales_performa_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('sales_performa_id');
			$table->integer('item_id');
			$table->float('unit_price')->default('0');
			$table->float('sales_price')->default('0');
			$table->float('purchase_price')->default('0');
			$table->integer('unit_of_measure_id')->nullable();
			$table->double('amount')->default('0');
			$table->string('discount_type', 10)->default('percent');
			$table->float('discount_amount')->default('0');
			$table->float('taxes_amount')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('sales_performa_items');
	}
}