<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->nullable();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('phone')->nullable();
			$table->string('telephone')->nullable();
			$table->json('address')->nullable();
			$table->float('initial_balance')->default('0');
			$table->float('credit_balance')->default('0');
			$table->float('debit_balance')->default('0');
			$table->string('type', 10)->default('BOTH');
			$table->text('notes')->nullable();
			$table->string('national_id')->nullable();
			$table->float('min_credit')->nullable()->default('0');
			$table->float('min_debit')->default('0');
			$table->float('max_debit')->nullable()->default('0');
			$table->float('max_credit')->nullable()->default('0');
			$table->enum('invoice_type', array(''piece'', ''half'', ''whole_sale''));
			$table->integer('installment_days')->default('0');
			$table->boolean('is_active')->default(1);
			$table->integer('group_id')->nullable();
			$table->string('country')->nullable();
			$table->string('governorate')->nullable();
			$table->string('city')->nullable();
			$table->string('fax')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}