<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryAdjustmentsTable extends Migration {

	public function up()
	{
		Schema::create('inventory_adjustments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('inventory_id');
			$table->string('title', 255)->nullable();
			$table->date('date')->nullable();
			$table->integer('created_by')->nullable();
			$table->string('status', 10)->default('OPEN');
			$table->date('confirmed_at')->nullable();
			$table->integer('confirmed_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('inventory_adjustments');
	}
}