<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesMenTable extends Migration {

	public function up()
	{
		Schema::create('sales_men', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_id')->nullable();
			$table->string('code')->nullable();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->text('address')->nullable();
			$table->string('phone')->nullable();
			$table->float('target_amount')->default('0');
			$table->float('comission')->default('0');
			$table->text('notes')->nullable();
			$table->boolean('is_active')->default(1);
			$table->integer('created_by')->nullable();
			$table->integer('shift_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sales_men');
	}
}