<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('name')->nullable();
			$table->string('code')->nullable();
			$table->json('description')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('brand_id')->nullable();
			$table->float('purchase_price')->default('0');
			$table->float('sale_price')->default('0');
			$table->float('unit_price')->default('0');
			$table->integer('unit_of_measures');
			$table->string('item_number')->nullable();
			$table->string('barcode')->nullable();
			$table->double('min_sale_amount')->default('0');
			$table->double('max_sale_amount')->default('0');
			$table->date('expire_date')->nullable();
			$table->double('min_stock')->default('0');
			$table->float('discount_amount')->default('0');
			$table->string('discount_type')->default('%');
			$table->boolean('active_taxes')->default(0);
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}