<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransferItemsTable extends Migration {

	public function up()
	{
		Schema::create('transfer_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('transfer_id');
			$table->integer('item_id');
			$table->integer('inventory_item_id');
			$table->double('amount')->default('0');
			$table->float('sale_price')->default('0');
			$table->float('purchase_price')->default('0');
			$table->float('unit_price')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('transfer_items');
	}
}