<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitOfMeasuresTable extends Migration {

	public function up()
	{
		Schema::create('unit_of_measures', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('parent_id');
			$table->json('name')->nullable();
			$table->float('amount')->default('0');
			$table->float('parent_amount')->default('0');
			$table->float('width')->default('0');
			$table->float('height')->default('0');
			$table->float('length')->default('0');
			$table->float('volume')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('unit_of_measures');
	}
}