<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('user_name', 255);
			$table->boolean('is_active')->default(1);
			$table->string('remember_token', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->integer('branch_id');
			$table->integer('role_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}