<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdditionsTable extends Migration {

	public function up()
	{
		Schema::create('additions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('type');
			$table->string('name', 199);
			$table->decimal('price', 10,2);
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('additions');
	}
}