<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 199);
			$table->integer('category_id')->unsigned();
			$table->decimal('price', 10,2);
			$table->string('description', 255)->nullable();
			$table->enum('type', array('0', '1'));
			$table->integer('viewer')->nullable()->default('0');
			$table->string('time', 199)->nullable();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}