<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 199);
			$table->string('phone', 11)->unique()->nullable();
			$table->string('email', 199)->unique();
			$table->string('image', 199)->nullable();
			$table->string('address', 199)->nullable();
			$table->string('identity', 199)->nullable();
			$table->string('license', 199)->nullable();
			$table->string('vehicle_registration_number', 199)->nullable();
			$table->string('bank_number', 11)->nullable();
			$table->string('insurance_number', 199)->nullable();
			$table->enum('type', array('1', '2', '3', '4'));
			$table->enum('driver_type', array('0', '1'))->nullable();
			$table->string('password', 199);
			$table->integer('active')->nullable()->default('0');
			$table->decimal('latitude', 10,8)->nullable();
			$table->decimal('longitude', 10,8)->nullable();
			$table->integer('city_id')->nullable();
			$table->string('api_token', 199)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}