<?php

namespace Products;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'name', 'modal', 'price', 'icon_url', 'is_active', 'ordered');

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

}