<?php

namespace Products;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'name', 'modal', 'price', 'icon_url', 'is_active', 'ordered');

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

}