<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('item_section_id')->unsigned()->nullable();
			$table->string('name');
			$table->float('modal')->nullable();
			$table->float('price');
			$table->text('icon_url')->nullable();
			$table->boolean('is_active')->default(1);
			$table->integer('ordered')->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}