<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('type');
			$table->string('name');
			$table->date('birthdate')->nullable();
			$table->bigInteger('national_id')->nullable();
			$table->text('address');
			$table->string('blood_type');
			$table->boolean('gender');
			$table->bigInteger('company_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}