<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 255);
			$table->string('name_en', 255);
			$table->enum('continent', array('Asia', 'Africa', 'NorthAmerica', 'SouthAmerica', 'Antarctica', 'Europe', 'Australia'));
			$table->timestamps();
			$table->softDeletes();
			$table->string('flag_path', 255);
			$table->string('phone_code', 255);
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}