<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CountryGroup extends Eloquent {

	protected $table = 'country_group';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'group_id');

	public function group()
	{
		return $this->belongsTo('Group');
	}

	public function country()
	{
		return $this->belongsTo('Country');
	}

}