<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderType extends Eloquent {

	protected $table = 'order_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'price');

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function sections()
	{
		return $this->hasMany('Section');
	}

}