<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionsTable extends Migration {

	public function up()
	{
		Schema::create('sections', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_type_id')->unsigned();
			$table->bigInteger('group_id')->unsigned();
			$table->string('name', 255);
			$table->integer('order');
			$table->integer('is_visible')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sections');
	}
}