<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class LeaveType extends Model 
{

    protected $table = 'leave_types';
    public $timestamps = true;
    protected $fillable = array('name', 'status');

    public function leavePolicies()
    {
        return $this->hasMany('LeavePolicy');
    }

    public function users()
    {
        return $this->belongsToMany('User')->withPivot('no_of_days', 'from_date', 'to_date', 'noted', 'approved');
    }

}