<?php

class LeavePolicy extends Eloquent {

	protected $table = 'leave_policies';
	public $timestamps = true;
	protected $fillable = array('name', 'leave_type_id');

	public function leaveType()
	{
		return $this->belongsTo('LeaveType', 'leave_type_id');
	}

	public function leavePolicyDetails()
	{
		return $this->hasMany('LeavePolicyDetail');
	}

	public function users()
	{
		return $this->belongsToMany('User')->withPivot('leave_balance');
	}

}