<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'emp_status_id', 'cnic', 'mobile', 'alt_phone', 'email', 'join_date', 'address', 'designation_id', 'photo');

	public function empStatus()
	{
		return $this->belongsTo('EmpStatus', 'emp_status_id');
	}

	public function designation()
	{
		return $this->belongsTo('Designation', 'designation_id');
	}

	public function attendance()
	{
		return $this->hasMany('Attendace');
	}

	public function leavePolicies()
	{
		return $this->belongsToMany('LeavePolicy')->withPivot('leave_balance');
	}

	public function leaveTypes()
	{
		return $this->belongsToMany('LeaveType')->withPivot('no_of_days', 'from_date', 'to_date', 'noted', 'approved');
	}

}