<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaveTypeUserTable extends Migration {

	public function up()
	{
		Schema::create('leave_type_user', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('leave_type_id')->unsigned();
			$table->integer('no_of_days');
			$table->date('from_date');
			$table->date('to_date');
			$table->text('noted');
			$table->boolean('approved');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('leave_type_user');
	}
}