<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('emp_status_id')->unsigned();
			$table->integer('cnic')->unsigned();
			$table->integer('mobile');
			$table->integer('alt_phone');
			$table->string('email', 255);
			$table->date('join_date');
			$table->string('address', 255);
			$table->integer('designation_id')->unsigned();
			$table->string('photo', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}