<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->integer('food_id')->unsigned()->index();
			$table->string('qty');
			$table->string('is_gift');
			$table->string('price');
			$table->timestamps();
			$table->bigInteger('order_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}