<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Ads', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sizes', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturant_setting', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('extra', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('extra_food', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('extra_food', function(Blueprint $table) {
			$table->foreign('extra_food_id')->references('id')->on('extra')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('feq_cateogry_id')->references('id')->on('faq_cateogries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Ads', function(Blueprint $table) {
			$table->dropForeign('Ads_category_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_resturant_id_foreign');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->dropForeign('foods_category_id_foreign');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->dropForeign('foods_size_id_foreign');
		});
		Schema::table('sizes', function(Blueprint $table) {
			$table->dropForeign('sizes_food_id_foreign');
		});
		Schema::table('resturant_setting', function(Blueprint $table) {
			$table->dropForeign('resturant_setting_resturant_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_resturant_id_foreign');
		});
		Schema::table('extra', function(Blueprint $table) {
			$table->dropForeign('extra_food_id_foreign');
		});
		Schema::table('extra_food', function(Blueprint $table) {
			$table->dropForeign('extra_food_food_id_foreign');
		});
		Schema::table('extra_food', function(Blueprint $table) {
			$table->dropForeign('extra_food_extra_food_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_resturant_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_food_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_feq_cateogry_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_resturant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_table_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_type_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_food_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
	}
}