<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'district_id', 'password', 'reset_code');

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function notifications()
	{
		return $this->morphToMany('App\Models\Notification');
	}

	public function district()
	{
		return $this->belongsTo('App\Models\District');
	}

}