<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePathsTable extends Migration {

	public function up()
	{
		Schema::create('paths', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('start_lat', 191);
			$table->string('start_long', 191);
			$table->string('start_address', 191);
			$table->tinyInteger('status');
			$table->date('start_date');
			$table->time('start_time');
			$table->time('end_time');
			$table->bigInteger('user_id')->unsigned();
			$table->string('total_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('paths');
	}
}