<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('type_id')->unsigned();
			$table->integer('city_id')->unsigned()->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('publisher_id')->unsigned()->nullable();
			$table->boolean('availability')->nullable();
			$table->string('address')->nullable();
			$table->integer('order')->unsigned()->nullable();
			$table->string('status')->nullable();
			$table->integer('price')->nullable();
			$table->string('code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}