<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username')->unique();
			$table->integer('score')->default('0');
			$table->string('email')->unique();
			$table->string('password', 60);
			$table->boolean('is_admin')->default(false);
			$table->rememberToken('rememberToken');
			$table->timestamps();
			$table->string('theme')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}