<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilmsTable extends Migration {

	public function up()
	{
		Schema::create('films', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug')->unique();
			$table->integer('quality_id')->unsigned()->nullable()->index();
			$table->integer('version_id')->unsigned()->nullable()->index();
			$table->string('description')->nullable();
			$table->integer('duration');
			$table->string('release_date', 20);
			$table->string('imdb_id')->nullable();
			$table->string('allocine_id')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('films');
	}
}