<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Film extends Model 
{

    protected $table = 'films';
    public $timestamps = true;

    public function genres()
    {
        return $this->belongsToMany('App\Genre', 'genre_film', 'genre_id', 'film_id');
    }

    public function creators()
    {
        return $this->belongsToMany('App\Person', 'creator_film', 'creator_id', 'film_id');
    }

    public function stars()
    {
        return $this->belongsToMany('App\Person', 'star_film', 'star_id', 'film_id');
    }

    public function quality()
    {
        return $this->belongsTo('App\Quality');
    }

    public function version()
    {
        return $this->belongsTo('App\Version');
    }

    public function players()
    {
        return $this->hasMany('App\Player');
    }

}