<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Serie extends Model 
{

    protected $table = 'series';
    public $timestamps = true;

    public function genres()
    {
        return $this->belongsToMany('App\Genre', 'genre_serie', 'genre_id', 'serie_id');
    }

    public function creators()
    {
        return $this->belongsToMany('App\Person', 'creator_serie', 'creator_id', 'serie_id');
    }

    public function stars()
    {
        return $this->belongsToMany('App\Person', 'star_serie', 'star_id', 'serie_id');
    }

    public function episodes()
    {
        return $this->hasMany('App\Episode');
    }

    public function quality()
    {
        return $this->belongsTo('App\Quality');
    }

}