<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeopleTable extends Migration {

	public function up()
	{
		Schema::create('people', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstname');
			$table->string('lastname');
			$table->string('suffix')->nullable();
			$table->string('slug');
			$table->string('dob')->nullable();
			$table->enum('gender', array('male', 'female'));
			$table->string('imdb_id')->nullable();
			$table->string('allocine_id')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('people');
	}
}