<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('series', function(Blueprint $table) {
			$table->foreign('quality_id')->references('id')->on('qualities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('episodes', function(Blueprint $table) {
			$table->foreign('serie_id')->references('id')->on('series')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('episodes', function(Blueprint $table) {
			$table->foreign('version_id')->references('id')->on('versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('films', function(Blueprint $table) {
			$table->foreign('quality_id')->references('id')->on('qualities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('films', function(Blueprint $table) {
			$table->foreign('version_id')->references('id')->on('versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('genre_serie', function(Blueprint $table) {
			$table->foreign('genre_id')->references('id')->on('genres')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('genre_serie', function(Blueprint $table) {
			$table->foreign('serie_id')->references('id')->on('series')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('creator_serie', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('people')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('creator_serie', function(Blueprint $table) {
			$table->foreign('serie_id')->references('id')->on('series')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('star_serie', function(Blueprint $table) {
			$table->foreign('star_id')->references('id')->on('people')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('star_serie', function(Blueprint $table) {
			$table->foreign('serie_id')->references('id')->on('series')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('genre_film', function(Blueprint $table) {
			$table->foreign('genre_id')->references('id')->on('genres')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('genre_film', function(Blueprint $table) {
			$table->foreign('film_id')->references('id')->on('films')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('creator_film', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('people')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('creator_film', function(Blueprint $table) {
			$table->foreign('film_id')->references('id')->on('films')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('star_film', function(Blueprint $table) {
			$table->foreign('star_id')->references('id')->on('people')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('star_film', function(Blueprint $table) {
			$table->foreign('film_id')->references('id')->on('films')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('film_id')->references('id')->on('films')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('episode_id')->references('id')->on('episodes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('series', function(Blueprint $table) {
			$table->dropForeign('series_quality_id_foreign');
		});
		Schema::table('episodes', function(Blueprint $table) {
			$table->dropForeign('episodes_serie_id_foreign');
		});
		Schema::table('episodes', function(Blueprint $table) {
			$table->dropForeign('episodes_version_id_foreign');
		});
		Schema::table('films', function(Blueprint $table) {
			$table->dropForeign('films_quality_id_foreign');
		});
		Schema::table('films', function(Blueprint $table) {
			$table->dropForeign('films_version_id_foreign');
		});
		Schema::table('genre_serie', function(Blueprint $table) {
			$table->dropForeign('genre_serie_genre_id_foreign');
		});
		Schema::table('genre_serie', function(Blueprint $table) {
			$table->dropForeign('genre_serie_serie_id_foreign');
		});
		Schema::table('creator_serie', function(Blueprint $table) {
			$table->dropForeign('creator_serie_creator_id_foreign');
		});
		Schema::table('creator_serie', function(Blueprint $table) {
			$table->dropForeign('creator_serie_serie_id_foreign');
		});
		Schema::table('star_serie', function(Blueprint $table) {
			$table->dropForeign('star_serie_star_id_foreign');
		});
		Schema::table('star_serie', function(Blueprint $table) {
			$table->dropForeign('star_serie_serie_id_foreign');
		});
		Schema::table('genre_film', function(Blueprint $table) {
			$table->dropForeign('genre_film_genre_id_foreign');
		});
		Schema::table('genre_film', function(Blueprint $table) {
			$table->dropForeign('genre_film_film_id_foreign');
		});
		Schema::table('creator_film', function(Blueprint $table) {
			$table->dropForeign('creator_film_creator_id_foreign');
		});
		Schema::table('creator_film', function(Blueprint $table) {
			$table->dropForeign('creator_film_film_id_foreign');
		});
		Schema::table('star_film', function(Blueprint $table) {
			$table->dropForeign('star_film_star_id_foreign');
		});
		Schema::table('star_film', function(Blueprint $table) {
			$table->dropForeign('star_film_film_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_film_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_episode_id_foreign');
		});
	}
}