<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email');

	public function posts()
	{
		return $this->morphedByMany('App\Models\Post', 'clientable');
	}

	public function governorates()
	{
		return $this->morphedByMany('App\Models\Governorate', 'clientable');
	}

	public function bloodTypes()
	{
		return $this->morphedByMany('App\Models\BloodType', 'clientable');
	}

	public function notifications()
	{
		return $this->morphedByMany('App\Models\Notification', 'clientable');
	}

	public function donation_requests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function tokens()
	{
		return $this->hasMany('App\Models\Token');
	}

}