<?php

namespace App\Models;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;
	protected $fillable = array('title', 'image', 'content');

	public function clients()
	{
		return $this->morphToMany('App\Models\Client', 'clientable');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

}