<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('Employees', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('phone_1');
			$table->string('phone_2');
			$table->string('title');
			$table->bigInteger('position_id')->unsigned();
			$table->bigInteger('manager_id')->unsigned();
			$table->bigInteger('seniormanager_id')->unsigned();
			$table->bigInteger('divhead_id')->unsigned();
			$table->bigInteger('recruiter_id')->unsigned();
			$table->datetime('archived_at')->nullable();
			$table->string('status')->nullable();
			$table->date('start_date')->nullable();
			$table->text('avatar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Employees');
	}
}