<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorProductTable extends Migration {

	public function up()
	{
		Schema::create('vendor_product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('vendor_id');
			$table->integer('product_id');
			$table->string('vendor_sku');
			$table->integer('min_order_qty');
			$table->integer('lead_time');
			$table->enum('auto_po_rounding', array('"RoundUp"', '"Exact"', '"RoundProperly"'));
			$table->string('packaging');
			$table->boolean('status');
			$table->json('pricing_tiers');
			$table->json('unit_of_measure');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendor_product');
	}
}